% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catseyes.R
\name{catseyes}
\alias{catseyes}
\title{catseyes}
\usage{
catseyes(
  x,
  ymean,
  yse,
  dx = 0.1,
  conf = 0.95,
  se.only = TRUE,
  col = "black",
  shade = rgb(0.05, 0.05, 0.05, 0.2),
  lwd = 1,
  plot.mean.line = FALSE,
  fTransform = NULL
)
}
\arguments{
\item{x}{numeric horizontal position(s); if factor, will be converted to integer in factor level order}

\item{ymean}{numeric mean(s)}

\item{yse}{numeric standard error(s); may use standard deviation(s) for population level plots}

\item{dx}{specifies the width (in x direction) of the catseye interval(s)}

\item{conf}{specifies the confidence of the confidence interval (conf=.95 for alpha=.05)}

\item{se.only}{boolean, if TRUE (default) will shade only +/- 1 standard error about the mean, overriding conf,
otherwise if FALSE will shade the confidence interval (per conf) about the mean}

\item{col}{specifies the color of the outline of the catseye, as well as the interval point & line, if shown}

\item{shade}{specifies the color of the shaded confidence region}

\item{lwd}{sets the line width of the interval and outline}

\item{plot.mean.line}{boolean, draws a horizontal line at the position of the mean if TRUE}

\item{fTransform}{Optional function to transform catseye plot from normal distribution (as with analyzing log-tranformed data, see example under catseyesplot)}
}
\description{
The catseyes() function is used to plot catseye interval(s) onto a an existing
basic R plot background.
Catseye plots illustrate the normal distribution of the mean (picture a normal bell curve
reflected over its base and rotated 90 degrees), with a shaded confidence interval; they
are an intuitive way of illustrating and comparing normally distributed estimates, and are
arguably a superior alternative to standard confidence intervals, since they show the full
distribution rather than fixed quantile bounds.
The catseyes() function requires pre-calculated means and standard errors (or standard deviations), provided
as numeric vectors; this allows the flexibility of obtaining this information from a
variety of sources, such as direct calculation or prediction from a model -- see examples below.
NOTE:  The drawn vertical range of the outline spans 99.8\% of the distribution of the mean.
}
\examples{
#Show catseye plots for 4 groups with means of c(-3,2,-1,6)
#    and standard errors of c(1,2,4,3)
plot(NULL,xlim=c(.5,4.5),ylim=c(-10,10),xlab="",ylab="",main="4 Groups",xaxt="n")
axis(1,at=1:4,labels = c("Group1","Group2","Group3","Group4"))
catseyes(1:4,ymean=c(-3,2,-1,6),yse=c(1,2,4,3))
#Optionally, add points and lines (usually lines only when joining time sequence)
lines(1:4,c(-3,2,-1,6),type="b")
}
\references{
Cumming, G. (2014). The new statistics: Why and how. Psychological Science, 27, 7-29. <doi:10.1177/0956797613504966> pmid:24220629 \cr
\url{http://www.psychologicalscience.org/index.php/publications/observer/2014/march-14/theres-life-beyond-05.html}
}
\author{
Clark R. Andersen \email{crandersen@mdanderson.org}
}
