% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_if_cat.R
\name{mutate_if_cat}
\alias{mutate_if_cat}
\alias{mutate_if_cat.default}
\alias{mutate_if_cat.data.table}
\alias{mutate_if_cont}
\alias{mutate_if_cont.default}
\alias{mutate_if_cont.data.table}
\title{mutate_if_cat, mutate_if_cont}
\usage{
mutate_if_cat(.tbl, .funs, ...)

\method{mutate_if_cat}{default}(.tbl, .funs, ...)

\method{mutate_if_cat}{data.table}(.tbl, .funs, ...)

mutate_if_cont(.tbl, .funs, ...)

\method{mutate_if_cont}{default}(.tbl, .funs, ...)

\method{mutate_if_cont}{data.table}(.tbl, .funs, ...)
}
\arguments{
\item{.tbl}{table}

\item{.funs}{functions see \code{\link[dplyr:mutate_if]{dplyr::mutate_if()}}}

\item{...}{additional parameters}
}
\value{
An object of class \code{.tbl} in with columns mutated according to \code{.funs}
}
\description{
mutates only categorical|continuous columns
}
\details{
Mutates categorical or continuous columns.

The data.table variants do this as
}
\examples{

 data(iris)

\dontrun{
  iris \%>\% mutate_if_cat( as.character )

  library(data.table)
  setDT(iris)
  class(iris$Species)
  iris \%>\% mutate_if_cat( as.character )
  class(iris1$Species)  # character
  class(iris2)

  iris \%>\% mutate_if_cont( add, 2 )
}

}
\seealso{
Similar to \code{\link[dplyr:mutate_if]{dplyr::mutate_if()}}
}
