% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempview.R
\name{drop_global_temp_view}
\alias{drop_global_temp_view}
\alias{drop_temp_view}
\title{Temporary View}
\usage{
drop_global_temp_view(sc, view)

drop_temp_view(sc, view)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{view}{\code{character(1)}. The name of the temporary view to be dropped.}
}
\value{
A \code{logical(1)} vector indicating whether the temporary view was dropped
(\code{TRUE}) or not (\code{FALSE}).
}
\description{
\itemize{
\item \code{drop_global_temp_view()}: Drops the global temporary view with the given
view name in the catalog.
\item \code{drop_temp_view()}: Drops the local temporary view with the given view name
in the catalog. Local temporary view is session-scoped. Its lifetime is the
lifetime of the session that created it, i.e. it will be automatically
dropped when the session terminates. It's not tied to any databases.
}
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
mtcars_spark <- sparklyr::copy_to(dest = sc, df = mtcars)

# We can check which temporary tables are in scope
list_tables(sc = sc)

# And then drop those we wish to drop
drop_temp_view(sc = sc, view = "mtcars")
}

}
\seealso{
\code{\link[=list_tables]{list_tables()}}
}
