% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{create_table}
\alias{create_table}
\title{Create A Table}
\usage{
create_table(sc, table, path, source, ...)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{table}{\code{character(1)}. The name of the table to create.}

\item{path}{\code{character(1)}. The path to use to create the table.}

\item{source}{\code{character(1)}. The data source to use to create the table such
as \code{"parquet"}, \code{"csv"}, etc.}

\item{...}{Additional options to be passed to the \code{createTable} method.}
}
\value{
A \code{tbl_spark}.
}
\description{
Creates a table, in the hive warehouse, from the given path and returns the
corresponding \code{DataFrame}. The table will contain the contents of the file
that is in the \code{path} parameter.
}
\details{
The default data source type is parquet.
This can be changed using \code{source} or setting the configuration option
\code{spark.sql.sources.default} when creating the spark session using or after
you have created the session using

\if{html}{\out{<div class="sourceCode r">}}\preformatted{config <- sparklyr::spark_config()
config[["spark.sql.sources.default"]] <- "csv"
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=cache_table]{cache_table()}}, \code{\link[=get_table]{get_table()}}, \code{\link[=list_tables]{list_tables()}}, \code{\link[=refresh_table]{refresh_table()}},
\code{\link[=table_exists]{table_exists()}}, \code{\link[=uncache_table]{uncache_table()}}
}
