% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtpois}
\alias{dtpois}
\alias{ptpois}
\alias{qtpois}
\alias{rtpois}
\title{Density function of Truncated Poisson Distribution}
\usage{
dtpois(x, lambda, min = 0, max = 1e+09)

ptpois(q, lambda, min = 0, max = 1e+09)

qtpois(p, lambda, min = 0, max = 1e+09)

rtpois(n, lambda, min = 0, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{lambda}{Distribution parameter}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Poisson Distribution

Cumulative probability function of Truncated Poisson Distribution

Quantile function of Truncated Poisson Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Poisson Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtpois(3,5)
ptpois(3,5)
qtpois(0.6,5)
rtpois(100,5)
}
