% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{methods}
\name{setDf<-}
\alias{setDf<-}
\alias{setDf<-,CopulaObj,numeric-method}
\alias{setDf,ANY-method}
\title{Set the degree of freedom for t Copula.}
\usage{
setDf(this, ...) <- value

\S4method{setDf}{CopulaObj,numeric}(this) <- value
}
\arguments{
\item{this}{Copula Object}

\item{...}{Additional function arguments}

\item{value}{The degree of freedom. The default value is 3.}
}
\description{
Set the degree of freedom for t Copula.
}
\examples{
library(cascsim)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
cop <- new("CopulaObj", type="t", param=c(0.5),marginal=list(dist1=dist1,dist2=dist2),dimension=2)
setDf(cop) <- 5
}
