% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{methods}
\name{getCopula}
\alias{getCopula}
\alias{getCopula,CopulaObj-method}
\alias{getCopula,ANY-method}
\title{Get the R copula object.}
\usage{
getCopula(object, ...)

\S4method{getCopula}{CopulaObj}(object)
}
\arguments{
\item{object}{R copula object}

\item{...}{Additional parameters that may or may not be used}
}
\description{
Get the R copula object.
}
\examples{
library(cascsim)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
nom.cop <- new("CopulaObj", param=c(0.5),marginal=list(dist1=dist1,dist2=dist2),dimension=2)
getCopula(nom.cop)
}
