% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-decoration.R
\name{text_decoration}
\alias{text_decoration}
\title{Text decoration}
\usage{
text_decoration(x, decoration)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{decoration}{A character string specifying a decoration. One of,
\itemize{
\item \code{"underline"}
\item \code{"strike"}
\item \code{"none"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_dectoration()} function adjusts how text is decorated within a tag
element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    text_decoration("strike"),
  "TODO: buy milk"
)

div(
  .style \%>\%
    text_emphasis(theme_danger()) \%>\%
    text_decoration("underline"),
  "Red AND underlined!"
)

}
\seealso{
Other text utilities: 
\code{\link{text_alignment}()},
\code{\link{text_break}()},
\code{\link{text_color}()},
\code{\link{text_height}()},
\code{\link{text_selection}()},
\code{\link{text_style}()},
\code{\link{text_transform}()},
\code{\link{text_weight}()},
\code{\link{text_wrap}()}
}
\concept{text utilities}
