% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overflow-all.R
\name{overflow_all}
\alias{overflow_all}
\alias{overflow_horizontal}
\alias{overflow_vertical}
\title{Content overflow}
\usage{
overflow_all(x, behavior)

overflow_horizontal(x, behavior)

overflow_vertical(x, behavior)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{behavior}{A character string specifying the content overflow behavior. One of,
\itemize{
\item \code{"auto"}
\item \code{"hidden"}
\item \code{FALSE}
\item \code{"visible"}
\item \code{"scroll"}
\item \code{TRUE}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \verb{overflow_*()} functions adjust how an element's content scrolls.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    width_relative(25) \%>\%
    overflow_horizontal("hidden"),
  "We've really got to drag on this sentence because if we don't",
  "then the example does not demonstrat the utility of the overflow",
  "function"
)

}
