% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/border-all.R
\name{border_all}
\alias{border_all}
\alias{border_top}
\alias{border_right}
\alias{border_bottom}
\alias{border_left}
\title{Add or remove borders}
\usage{
border_all(x, include = TRUE)

border_top(x, include = TRUE)

border_right(x, include = TRUE)

border_bottom(x, include = TRUE)

border_left(x, include = TRUE)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{include}{A boolean specifying to include a side. One of,
\itemize{
\item \code{TRUE}
\item \code{FALSE}

Defaults to \code{TRUE}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{border_all()} and \verb{border_<side>()} functions adjust a tag element's
borders.
}
\examples{

library(htmltools)

h3(
  .style \%>\%
    border_bottom() \%>\%
    border_color(theme_warning()) \%>\%
    text_color(theme_warning()),
  "Warning"
)

}
\concept{border}
