% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_age_groups.R
\name{validate_age_groups}
\alias{validate_age_groups}
\title{Validate Age Group Labels}
\usage{
validate_age_groups(dat)
}
\arguments{
\item{dat}{A data frame containing an \code{ageg} column with age group labels.}
}
\value{
NULL (invisibly). The function is called for its side effect of
stopping execution if invalid age groups are found.
}
\description{
Checks that age group labels in a dataset match expected formats.
}
\details{
Expected age group labels are:
\itemize{
\item Five-year age bands: '00_04', '05_09', ..., '80_84'
\item Open-ended group: '85'
\item Special categories: 'total', 'DCO', 'MV'
}
}
\examples{
dat <- data.frame(ageg = c("00_04", "05_09", "10_14"))
validate_age_groups(dat)
}
