% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_raw}
\alias{stat_raw}
\title{Unmatched callback rates}
\usage{
stat_raw(x, method = "student", level = 0.95)
}
\arguments{
\item{x}{A \code{callback} object.}

\item{method}{estimation method, "cp" for Clopper-Pearson, "wilson" for Wilson
and "student" for Student (the default).}

\item{level}{A number, containing the level of the confidence intervals (0.95
by default).}
}
\value{
A \code{callback_stat} object with 2 components: specif and props.

\code{specif}: A list containing 
\itemize{
  \item\bold{convention:} string "raw callback rates". 
  \item\bold{cid:} convention on 3 characters.
  \item\bold{method:} the estimation method, "cp" for Clopper-Pearson, 
  "wilson" for Wilson and "student" for "Student" (the default).
  \item\bold{level:} the level of the confidence intervals (0.95 by default).
  \item\bold{source:} the R stats function used to compute the statistics 
  (binom.test, prop.test or t.test).
  \item\bold{name:} the name of the statistic (Fisher, Pearson or Student).
}
\code{props}: a data frame containing the following variables.
\itemize{
\item\bold{tests: }number of tests
\item\bold{callback: }number of callbacks
\item\bold{inf_p_callback: }callback rate lower bound
\item\bold{p_callback: }callback rate
\item\bold{sup_p_callback: }callback rate upper bound
}
}
\description{
Number and proportion of callbacks for all the candidates.
}
\examples{
data(labour2)
x <- callback(data=labour2,cluster="offer",candid="hist",callback="callback")
str(stat_raw(x))

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
doi:10.2307/2331986.

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. doi:10.2307/2276774.
}
\author{
Emmanuel Duguet
}
