% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icelandic.R
\name{icelandic_date}
\alias{icelandic_date}
\alias{as_icelandic}
\title{Icelandic calendar dates}
\usage{
icelandic_date(
  year = integer(),
  season = integer(),
  week = integer(),
  weekday = integer()
)

as_icelandic(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{season}{A numeric vector of seasons (1 = Summer, 2 = Winter)}

\item{week}{A numeric vector of weeks within the season (1 to 28)}

\item{weekday}{A number vector containing day of week (0 = Sunday, 1 = Monday,
..., 6 = Saturday))}

\item{date}{A numeric vector of dates}
}
\value{
An icelandic vector object
}
\description{
The Icelandic calendar, still in use in Iceland, divides times into
7-day weeks and two seasons: Summer and Winter. Summer starts on the first
Thursday after April 18th, and Winter 180 days earlier. Ordinary years have
52 weeks with leap years having 53 weeks. The leap week occurs every 5-7
years in midsummer.
}
\examples{
gregorian_date(2025, 4, 20:30) |>
  as_icelandic()
icelandic_date(2025, 1, 6, 0:6) |>
  day_of_week()
}
