% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bahai.R
\name{bahai_date}
\alias{bahai_date}
\alias{as_bahai}
\title{Bahá'í calendar dates}
\usage{
bahai_date(
  major = integer(),
  cycle = integer(),
  year = integer(),
  month = integer(),
  day = integer()
)

as_bahai(date)
}
\arguments{
\item{major}{A numeric vector of major periods}

\item{cycle}{A numeric vector of cycles}

\item{year}{A numeric vector of years within the cycles}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{date}{A numeric vector of dates}
}
\value{
A bahai vector object
}
\description{
The Bahá'í calendar is a solar calendar used in the Bahá'í faith comprising 18 months, with four or five
intercalary days each year. The New Year is at the northern Spring equinox,
corresponding to 21 March on the Gregorian calendar. Ayyám-i-Há is specified as month 20.
}
\examples{
tibble::tibble(
  gregorian = gregorian_date(2025, 2, 15) + 0:30,
  bahai = as_bahai(gregorian)
)
bahai_date(1, 10, 11, 3, 5:7)
}
\seealso{
\link{cal_bahai}, \link{bahai_new_year}
}
