% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_isbn.R
\name{ZoteroIsbn}
\alias{ZoteroIsbn}
\title{Search libraries using ISBN or MMS ID}
\usage{
ZoteroIsbn(keys, meta = list(), silent = TRUE, log = list())
}
\arguments{
\item{keys}{Keys to search with (e.g., ISBN or MMS ID)}

\item{meta}{A list collecting all metadata used to create , Default: list()}

\item{silent}{c2z is noisy, tell it to be quiet, Default: TRUE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
Query libraries using ISBN (or MMS ID) and fetch metadata
}
\details{
Please see
\href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Search libraries for ISBN metadata
  example <- ZoteroIsbn("978-1529797138")

  # Print index using `ZoteroIndex`
  if (any(nrow(example$data))) {
  ZoteroIndex(example$data) |>
    dplyr::select(name) |>
    print(width = 80)
  }
}
}
\seealso{
\code{\link[rvest]{rename}}, \code{\link[rvest]{html_children}},
 \code{\link[rvest]{html_attr}}, \code{\link[rvest]{html_text}},
 \code{\link[rvest]{reexports}}
 \code{\link[dplyr]{bind}}, \code{\link[dplyr]{distinct}},
 \code{\link[dplyr]{arrange}}
 \code{\link[tibble]{tibble}}
 \code{\link[httr]{RETRY}}
 \code{\link[stats]{setNames}}
 \code{\link[jsonlite]{toJSON, fromJSON}}
}
