% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bwd}
\alias{bwd}
\title{Backward procedure for the change point detection}
\usage{
bwd(y, alpha = 0.05, kmin = 3, lastkgroup = floor(0.01 * n),
  mu0 = NULL, normal = T, n.permute = 1000, h = 10)
}
\arguments{
\item{y}{observed data}

\item{alpha}{target level that detemines stopping criterion. Default is 0.05}

\item{kmin}{minimum length of segements for checking possible change points}

\item{lastkgroup}{We can abvoid chekcing possible change points when we have less groups than "lastkgroup" to improve computational efficiency. Default is 0.01 * n}

\item{mu0}{Baseline mean value whe detecting epidemic chang points. Defalut is \code{NULL}}

\item{normal}{if \code{TRUE} normal cutoff values are used, and if \code{FALSE} residual permuted cutoff values are used. Default is \code{TRUE}}

\item{n.permute}{number of permutation when computing the permuted cutoff. Defalut is 1000}

\item{h}{bandwidth size for variance esitimator}
}
\value{
bwd object that contains information of detected segments and significance levels
}
\description{
Implements backward procedure for detecting single or multiple change points.
}
\examples{
# simulated data
set.seed(1)
n <- 1000
L <- 10

mu0 <- -0.5

mu <- rep(mu0, n)
mu[(n/2 + 1):(n/2 + L)] <- mu0 + 1.6
mu[(n/4 + 1):(n/4 + L)] <- mu0 - 1.6
y <- mu + rnorm(n)
alpha <- c(0.01, 0.05)

# BWD
obj1 <- bwd(y, alpha = alpha)

# Modified for epidemic changes with a known basline mean, mu0.
obj2 <- bwd(y, alpha = alpha, mu0 = 0)

par(mfrow = c(2,1))
plot(obj1, y)
plot(obj2, y)

}
\references{
Shin, Wu, and Hao (2018+) A backward procedure for change-point detection with applications to copy number variation detection, arXiv:1812.10107.
}
\seealso{
\code{\link{plot.bwd}}
}
\author{
Seung Jun Shin, Yicaho Wu, Ning Hao
}
