% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_node.R
\name{table_model}
\alias{table_model}
\alias{model_node}
\title{Define a model node for business plan tables}
\usage{
table_model(..., valid_types, check_carry = TRUE)

model_node(carry, ..., revenue, expense)
}
\arguments{
\item{...}{Optional named lists of nodes (\code{table_model}) or nested sub-nodes (\code{model_node}),
      like subsections of this
section. You can use \code{model_node} recursive to define these named nodes. Just don't forget to give each a unique name.}

\item{valid_types}{Optional character string,
      the name of the type set to use for checking if all used revenue and expense
names are actually valid.}

\item{check_carry}{Logical,
      if \code{TRUE} all node names used und the nested list will be looked up if they are referenced by
\code{carry} somewhere down the line.}

\item{carry}{Optional character string, the name of another already defined named list,
      probably at the same level. The sum of that
list will then be used as the initial value for the calculation of this node.}

\item{revenue}{Optional character vector defining names defined as class revenue via \code{\link[businessPlanR:set_types]{set_types}}.}

\item{expense}{Optional character vector defining names defined as class expense via \code{\link[businessPlanR:set_types]{set_types}}.}
}
\value{
A nested, named list.
}
\description{
Tool to define a (possibly nested) model for generating tables for our business plan. The "model" is in fact a nested list.
}
\details{
If you define nested levels,
      you want to probably only want to combine this node with \code{carry} and neither \code{revenue}
nor \code{expense}.
}
\examples{
my_model <- table_model(
  "Basic Income"=model_node(
    revenue="Sale"
  ),
  "Basic Costs"=model_node(
    carry="Basic Income",
    expense=c(
      "Goods",
      "Operation"
    )
  ),
  valid_types="default",
  check_carry=TRUE
)
}
