% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_numbers.R
\name{nice_numbers}
\alias{nice_numbers}
\title{Format numbers in nice layout}
\usage{
nice_numbers(
  x,
  prefix,
  suffix,
  digits = 0L,
  width = NULL,
  nsmall = digits,
  space = c(html = "&#8239;", latex = "\\\\,")
)
}
\arguments{
\item{x}{The numeric value to format. Can be a single number, numeric vector, matrix,
      or data frame.}

\item{prefix}{An optional symbol to prepend, ignored if missing.}

\item{suffix}{An optional symbol to append, ignored if missing.}

\item{digits}{See \code{\link[base:round]{round}}.}

\item{width}{See \code{\link[base:format]{format}}.}

\item{nsmall}{See \code{\link[base:format]{format}}.}

\item{space}{Named character vector,
      a space definition to put between prefix/suffix and value.
Defaults to a thin space for both, LaTeX and HTML.
If you use provide one character, that one is used regardless of the output environment.}
}
\value{
A formatted character string.
}
\description{
Uses \code{\link[base:format]{format}} with some customized defaults.
It's being called by \code{\link[businessPlanR:kable_bpR]{kable_bpR}}.
}
\examples{
nice_numbers(12345.6789, suffix="€", digits=2)
}
