% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period_dates.R
\name{get_boundary}
\alias{get_boundary}
\title{Get date's business period boundary.}
\usage{
get_boundary(date = Sys.Date(), offset_period = 0,
  offset_type = "year", bus_period = "FY", boundary = "1st day",
  opt_fy_start = getOption("busdaterFYstart", default = "07-01"))
}
\arguments{
\item{date}{A date vector for which financial year is required.
Date must be POSIXct or POSIXlt or Date objects.}

\item{offset_period}{A positive or negative number  coercible to
integer to shift the year by,
e.g. in the case of \code{get_fy}, -1 for previous year, 1 for next year. More
generally in \code{page_boundaries} function it is a number of periods of
a specified period type}

\item{offset_type}{It is either \code{"month"} or \code{"year"}}

\item{bus_period}{It is either \code{"get_fy"} for financial year,
\code{"CE"} for calendar year or \code{"M"} for month}

\item{boundary}{Either \code{"1st day"} for the first day of the period or
\code{"last day"} for the end of the period.}

\item{opt_fy_start}{A string in the format of "MM-DD" representing the start
of financial year, e.g. "01-01" for 1st of January or "07-01" for 1st of July.
This package caters for financial years that have a fixed start date.
It does not cater for moving dates e.g. last Friday of September.}
}
\value{
A vector of dates.
}
\description{
The \code{get_boundary} will shift the input \code{date} vector by
a number of months and years i.e. \code{date + offset_period * offset_type}.
It will handle the typical business date arithmetic.
}
\examples{
# the 1st day of the current financial year
get_boundary()

# the last day of the current financial year
get_boundary(boundary = "last day")

# the last day of the last calendar year
get_boundary(offset_period = -1, bus_period = "CY", boundary = "last day")

# the last day of month 14 months from now
get_boundary(offset_period = 14, offset_type = "month",
                  bus_period = "M", boundary = "last day")

# The first day of financial years for dates 3 months before the given dates
get_boundary(as.Date(c("02/27/1992", "09/28/2022"), "\%m/\%d/\%Y"),
                  offset_period = -3, offset_type = "month",
                  bus_period = "FY", boundary = "1st day")

}
\seealso{
Other business date functions: \code{\link{FY}},
  \code{\link{get_fy}}, \code{\link{period_boundaries}}
}
\concept{business date functions}
