% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFunctions.R
\name{bubbleHMLegends}
\alias{bubbleHMLegends}
\title{Build Legend Trees for bubbleHeatmap Plots}
\usage{
bubbleHMLegends(
  sizeBreaks,
  colorBreaks,
  colorSeq,
  unitBase,
  diameter,
  context,
  legendHeight,
  legendTitles,
  showBubbleLegend = TRUE,
  showColorLegend = TRUE,
  name = "Legends",
  orientation = c("horizontal", "vertical")
)
}
\arguments{
\item{colorBreaks, sizeBreaks}{Character vectors of legend tick labels. The
min/max values will represent the range of color/size scales. If not supplied
then these will be generated using \code{\link[base]{pretty}}, to a range
outside data values (after values truncated to \code{colorLim}\\\code{sizeLim}
if applicable).}

\item{colorSeq}{Character vector of colors to be used in creating color
scale.}

\item{unitBase}{\code{\link[grid]{unit}} object indicating the size of one
plot grid box.}

\item{diameter}{Maximum diameter of bubbles as multiple of unitBase.}

\item{context}{\code{\link[grid]{gpar}} object to provide drawing context.
Will be applied to the parent viewport in the childrenvp slot of the gTree.}

\item{legendHeight}{Numeric, preferred height of legends in multiples of
\code{unitBase}. This will be supplied to  \code{\link[base]{pretty}}
function. If {sizeBreaks} vector is supplied then this will be ignored and
legend height will be \code{length(sizeBreaks)}.}

\item{legendTitles}{Character vector of legend titles. First string should be
the size legend title, second for the color legend.}

\item{showColorLegend, showBubbleLegend}{Should plot include legends for color
scale/bubble size?}

\item{name}{character string naming the gTree containing the function output.}

\item{orientation}{one of "horizontal" or "vertical", (default horizontal)
indicating whether legends should be arranged stacked or side by side.
Ignored if only one legend is required.}
}
\value{
A \code{\link[grid]{gTree}} object representing the bubbleHeatmap
legends requested by the showBubbleLegend and showColorLegend parameters.
}
\description{
Generate a bubble size legend and/or color legend for bubbleHeatmap plots.
}
\examples{
legends <- bubbleHMLegends(
  sizeBreaks = seq(0, 80, 10), colorBreaks = seq(-2, 2, 0.5), diameter = 0.8,
  context = gpar(cex = 0.8), colorSeq = c("#053061", "#2166AC", "#4393C3", "#92C5DE", "#D1E5F0",
  "#FDDBC7", "#F4A582", "#D6604D", "#B2182B", "#67001F"), unitBase = unit(0.5, "cm"),
  legendHeight = 9, legendTitles = c("Estimate", "NegLog10P"))
grid.draw(legends)
}
\seealso{
Other build functions: 
\code{\link{bubbleHeatmapList}()},
\code{\link{bubbleHeatmap}()},
\code{\link{multiPlotInput}()}
}
\concept{build functions}
