% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metafor.R
\name{augment.rma}
\alias{augment.rma}
\title{Augment data with information from a(n) rma object}
\usage{
\method{augment}{rma}(x, interval = c("prediction", "confidence"), ...)
}
\arguments{
\item{x}{An \code{rma} object such as those created by \code{\link[metafor:rma.uni]{metafor::rma()}},
\code{\link[metafor:rma.uni]{metafor::rma.uni()}}, \code{\link[metafor:rma.glmm]{metafor::rma.glmm()}}, \code{\link[metafor:rma.mh]{metafor::rma.mh()}},
\code{\link[metafor:rma.mv]{metafor::rma.mv()}}, or \code{\link[metafor:rma.peto]{metafor::rma.peto()}}.}

\item{interval}{For \code{rma.mv} models, should prediction intervals
(\code{"prediction"}, default) or confidence intervals (\code{"confidence"})
intervals be returned? For \code{rma.uni} models, prediction intervals are
always returned. For \code{rma.mh} and \code{rma.peto} models, confidence intervals
are always returned.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Augment accepts a model object and a dataset and adds
information about each observation in the dataset. Most commonly, this
includes predicted values in the \code{.fitted} column, residuals in the
\code{.resid} column, and standard errors for the fitted values in a \code{.se.fit}
column. New columns always begin with a \code{.} prefix to avoid overwriting
columns in the original dataset.

Users may pass data to augment via either the \code{data} argument or the
\code{newdata} argument. If the user passes data to the \code{data} argument,
it \strong{must} be exactly the data that was used to fit the model
object. Pass datasets to \code{newdata} to augment data that was not used
during model fitting. This still requires that at least all predictor
variable columns used to fit the model are present. If the original outcome
variable used to fit the model is not included in \code{newdata}, then no
\code{.resid} column will be included in the output.

Augment will often behave differently depending on whether \code{data} or
\code{newdata} is given. This is because there is often information
associated with training observations (such as influences or related)
measures that is not meaningfully defined for new observations.

For convenience, many augment methods provide default \code{data} arguments,
so that \code{augment(fit)} will return the augmented training data. In these
cases, augment tries to reconstruct the original data based on the model
object with varying degrees of success.

The augmented dataset is always returned as a \link[tibble:tibble]{tibble::tibble} with the
\strong{same number of rows} as the passed dataset. This means that the passed
data must be coercible to a tibble. If a predictor enters the model as part
of a matrix of covariates, such as when the model formula uses
\code{\link[splines:ns]{splines::ns()}}, \code{\link[stats:poly]{stats::poly()}}, or \code{\link[survival:Surv]{survival::Surv()}}, it is represented
as a matrix column.

We are in the process of defining behaviors for models fit with various
\code{na.action} arguments, but make no guarantees about behavior when data is
missing at this time.
}
\examples{
\dontshow{if (rlang::is_installed("metafor")) withAutoprint(\{ # examplesIf}

# load modeling library
library(metafor)

# generate data and fit
df <-
  escalc(
    measure = "RR",
    ai = tpos,
    bi = tneg,
    ci = cpos,
    di = cneg,
    data = dat.bcg
  )

meta_analysis <- rma(yi, vi, data = df, method = "EB")

# summarize model fit with tidiers
augment(meta_analysis)
\dontshow{\}) # examplesIf}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{.fitted}{Fitted or predicted value.}
  \item{.lower}{Lower bound on interval for fitted values.}
  \item{.moderator}{In meta-analysis, the moderators used to calculate the predicted values.}
  \item{.moderator.level}{In meta-analysis, the level of the moderators used to calculate the predicted values.}
  \item{.resid}{The difference between observed and fitted values.}
  \item{.se.fit}{Standard errors of fitted values.}
  \item{.upper}{Upper bound on interval for fitted values.}
  \item{.observed}{The observed values for the individual studies}

}
