% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmissing.R
\name{checkmissing}
\alias{checkmissing}
\alias{checkNA}
\alias{checkNA.default}
\alias{checkNULL}
\alias{checkNULL.default}
\title{Efficiently Check for (Non-)Missing Values}
\usage{
checkNA(x, ...)

\method{checkNA}{default}(x, op, inv = FALSE, ...)

checkNULL(x, ...)

\method{checkNULL}{default}(x, op, inv = FALSE, ...)
}
\arguments{
\item{x}{an object. \cr
For \code{checkNULL()}: a recursive vector or array (i.e. type of \code{list}). \cr
For \code{checkNA()}: an atomic vector or array (raw type not supported). \cr}

\item{...}{further arguments passed to or from methods.}

\item{op}{a single string, giving the operation to use. \cr
The following operations are supported:
\itemize{
\item "logical": checks for every element of \code{x} the presence/absence of missing values; returns a logical vector/array.
\item "raw": same as operation "logical",
except the result will be a raw vector/array (\code{01} = \code{TRUE}, \code{00} = FALSE),
which requires less memory.
\item "any": checks if any element is (not) missing.
\item "all": checks if all elements are (not) missing.
\item "count" or "sum": counts the number of elements that are (not) missing.
\item "which": gives the element indices that are (not) missing.
\item "first": gives the element index of the first (non-) missing element.
\item "last": gives the element index of the last (non-) missing element.
}}

\item{inv}{Boolean, indicating if the check should be inverted. \cr
If \code{inv = FALSE} (default), the operations check for missing elements. \cr
If \code{inv = TRUE}, the operations check for NOT missing elements. \cr \cr}
}
\value{
Output depends on the specification of argument \code{op}:
\itemize{
\item "logical": logical vector with the same length, names, and dimensions as \code{x}.
\item "raw": raw vector with the same length, names, and dimensions as \code{x}.
\item "any": \code{TRUE} or \code{FALSE}.
\item "all": \code{TRUE} or \code{FALSE}.
\item "count" or "sum": 53 bit integer scalar.
\item "which": vector of indices.
\item "first": the first index found, or \code{0} otherwise.
\item "last": the last index found, or \code{0} otherwise.
}
}
\description{
The \code{checkNULL()} function efficiently checks for the presence
(or absence) of \code{NULL} in every element of a list. \cr
The \code{checkNA()} function efficiently checks for the presence
(or absence) of \code{NA}/\code{NaN} in every element of an atomic vector. \cr
\cr
}
\examples{

# checkNA ====
x <- array(
  sample(c(-10:10, NA, NaN)), dim = 4:2
)
y <- array(
  sample(c(-10:10, NA, NaN)), dim = c(4,1,1)
)
broadcaster(x) <- broadcaster(y) <- TRUE

mx <- checkNA(x, "raw")
my <- checkNA(y, "raw")
bc.b(mx, my, "&")
bc.b(mx, my, "xor")
bc.b(mx, my, "nand")
bc.b(mx, my, "==")
bc.b(mx, my, "!=")
bc_ifelse(bc.b(mx, my, "|"), -1000L, x + y)


# checkNULL ====
x <- array(
  sample(list(letters, LETTERS, month.abb, month.name, NULL)), dim = 4:2
)
y <- array(
  sample(list(letters, LETTERS, month.abb, month.name, NULL)), dim = c(4,1,1)
)
broadcaster(x) <- broadcaster(y) <- TRUE

mx <- checkNULL(x, "raw")
my <- checkNULL(y, "raw")
bc.b(mx, my, "&")
bc.b(mx, my, "xor")
bc.b(mx, my, "nand")
bc.b(mx, my, "==")
bc.b(mx, my, "!=")
bc_ifelse(bc.b(mx, my, "|"), list(~ "Nothing"), bc.list(x, y, paste0))

}
