% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benefit_risk.R
\name{pbrisk}
\alias{pbrisk}
\alias{qbrisk}
\title{Calculate Quantiles and Probabilities}
\usage{
pbrisk(x, q, reference = NULL, direction = c("upper", "lower"))

qbrisk(x, p, reference = NULL)
}
\arguments{
\item{x}{output from a call to \code{brisk::br()} or \code{brisk::mcda()}.}

\item{q}{vector of quantiles.}

\item{reference}{a string indicating which group is the reference group which
is used to subtract scores from other groups.}

\item{direction}{the direction of the posterior probability to compute.}

\item{p}{a vector of probabilities from which to compute posterior quantiles.}
}
\value{
A tibble with the quantile and posterior probability of the
benefit-risk score for each group.
}
\description{
Calculates posterior quantiles and probabilities on
benefit-risk scores.
}
\examples{
set.seed(1132)
out <- br(
  benefit("CV", function(x) x, weight = 1),
  risk("DVT", function(x) - .5 * x, weight = 1),

  br_group(
    label = "PBO",
    CV = rnorm(1e4, .1),
    DVT = rnorm(1e4, .1)
  ),
  br_group(
    label = "TRT",
    CV = rnorm(1e4, 2),
    DVT = rnorm(1e4, 1)
  )
)

pbrisk(out, q = c(.03, .04))
pbrisk(out, q = c(.03, .04), direction = "lower")
pbrisk(out, q = c(.03, .04), reference = "PBO")

qbrisk(out, p = c(.025, .975))
qbrisk(out, p = c(.025, .975), reference = "PBO")
}
