% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-tables.R
\name{db_uc_tables_list}
\alias{db_uc_tables_list}
\title{List Tables (Unity Catalog)}
\usage{
db_uc_tables_list(
  catalog,
  schema,
  max_results = 50,
  omit_columns = TRUE,
  omit_properties = TRUE,
  omit_username = TRUE,
  include_browse = TRUE,
  include_delta_metadata = FALSE,
  include_manifest_capabilities = FALSE,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Name of parent catalog for tables of interest.}

\item{schema}{Parent schema of tables.}

\item{max_results}{Maximum number of tables to return (default: 50, max: 50).}

\item{omit_columns}{Whether to omit the columns of the table from the
response or not.}

\item{omit_properties}{Whether to omit the properties of the table from the
response or not.}

\item{omit_username}{Whether to omit the username of the table (e.g. owner,
updated_by, created_by) from the response or not.}

\item{include_browse}{Whether to include tables in the response for which the
principal can only access selective metadata for.}

\item{include_delta_metadata}{Whether delta metadata should be included in
the response.}

\item{include_manifest_capabilities}{Whether to include a manifest containing
capabilities the table has.}

\item{page_token}{Opaque token used to get the next page of results. Optional.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
List Tables (Unity Catalog)
}
\seealso{
Other Unity Catalog Table Management: 
\code{\link{db_uc_tables_delete}()},
\code{\link{db_uc_tables_exists}()},
\code{\link{db_uc_tables_get}()},
\code{\link{db_uc_tables_summaries}()}
}
\concept{Unity Catalog Table Management}
