% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculators.R
\name{calc_rate}
\alias{calc_rate}
\title{Interest Rate (RATE)}
\usage{
calc_rate(
  n,
  pv,
  fv = 0,
  pmt = 0,
  type = 0,
  guess = 0.1,
  max_iter = 100,
  tol = 1e-08
)
}
\arguments{
\item{n}{Number of periods.}

\item{pv}{Present value.}

\item{fv}{Future value.}

\item{pmt}{Payment per period (optional, default = 0).}

\item{type}{Payment timing: 0 for end of period, 1 for beginning of period.}

\item{guess}{Initial guess for the rate (default = 0.1).}

\item{max_iter}{Maximum number of iterations (default = 100).}

\item{tol}{Tolerance for convergence (default = 1e-8).}
}
\value{
Interest rate per period.
}
\description{
Calculates the interest rate per period.
}
\examples{
calc_rate(n = 12, pv = -1000, fv = 2000)
calc_rate(n = 60, pv = -20000, fv = 0, pmt = 386.66)

}
