% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{print.breakfast.cpts}
\alias{print.breakfast.cpts}
\title{Change-points estimated by the "breakfast" routine}
\usage{
\method{print}{breakfast.cpts}(x, by = c("method", "estimator"), ...)
}
\arguments{
\item{x}{a \code{breakfast.cpts} object}

\item{by}{if \code{by = 'method'}, change-point estimators are printed by method;
if \code{by = 'estimator'}, each change-point estimator is printed with the methods that detect it.}

\item{...}{current not in use}
}
\description{
Print method for objects of class \code{breakfast.cpts}
}
\examples{
f <- rep(rep(c(0, 1), each = 50), 5)
x <- f + rnorm(length(f)) * .5
print(breakfast(x, solution.path = 'all', model.selection = 'all'), by = 'method')
print(breakfast(x), by = 'estimator')
}
