% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{brand_sass_typography}
\alias{brand_sass_typography}
\title{Generate Sass variables for brand typography}
\usage{
brand_sass_typography(brand)
}
\arguments{
\item{brand}{A list or string of YAML representing the brand, or a path to a
brand.yml file.}
}
\value{
A list with one component:
\itemize{
\item \code{defaults}: Sass variable definitions with \code{!default} flag
}
}
\description{
Creates Sass variables for typography settings with the \code{brand_typography_} prefix.
Font size values in pixels are converted to rem units, and color references are resolved.
}
\examples{
brand <- list(
  typography = list(
    base = list(
      size = "16px",
      "line-height" = 1.5
    ),
    headings = list(
      weight = "bold",
      style = "normal"
    )
  )
)

brand_sass_typography(brand)

}
\seealso{
Other brand.yml Sass helpers: 
\code{\link{brand_sass_color}()},
\code{\link{brand_sass_color_palette}()},
\code{\link{brand_sass_defaults_bootstrap}()},
\code{\link{brand_sass_fonts}()}
}
\concept{brand.yml Sass helpers}
