% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swiss.R
\name{swiss}
\alias{swiss}
\title{Create a Swiss-system tournament}
\usage{
swiss(participants, ...)
}
\arguments{
\item{participants}{Character vector of participant names, or a data.frame
with a 'name' column and optional 'seed' column.}

\item{...}{Additional arguments passed to bracket constructors or
tournament stage-verb dispatch methods.}
}
\value{
A swiss_bracket object
}
\description{
Swiss system pairs participants by similar records each round.
}
\examples{
# Swiss system followed by top-cut playoffs
teams <- paste("Team", LETTERS[1:16])
trn <- tournament(teams) |>
  swiss("open", rounds = 5) |>
  single_elim("playoffs", take = top_n(8))
}
