% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_robin.R
\name{round_robin}
\alias{round_robin}
\title{Create a round robin tournament}
\usage{
round_robin(participants, ...)
}
\arguments{
\item{participants}{Character vector of participant names, or a data.frame
with a 'name' column and optional 'seed' column.}

\item{...}{Additional arguments passed to bracket constructors or
tournament stage-verb dispatch methods.}
}
\value{
A round_robin_bracket object
}
\description{
Round robin tournament where each participant plays every other participant.
}
\examples{
# Simple round robin
trn <- tournament(c("A", "B", "C", "D")) |>
  round_robin("groups")

# Multiple groups (World Cup style)
teams <- paste("Team", sprintf("\%02d", 1:32))
trn <- tournament(teams) |>
  round_robin("groups", groups = 8)
}
