% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rboss.R
\name{getOC}
\alias{getOC}
\title{Select Optimal cutoff for a biomarker}
\usage{
getOC(data, cutoff, type = 2)
}
\arguments{
\item{data}{A data frame which contains 3 columns for cox regression : survival time, censor status, Biomarker values.
2 columns for linear regression :  Y, X.}

\item{cutoff}{Numeric vector of candidate cutoffs.}

\item{type}{A number; if =1, will perform linear regression;if =2(default) will perform cox regerssion.}
}
\value{
Optimal cutoff for the biomarker, the FWER of the model
}
\description{
Given a set of data including survival time ,censor status and Biomarker values,
return the Optimal cutoff for the biomarker.
}
\examples{
cutoff=c(56,112,167,223,278,334,389,445)
    data(myGene)
    getOC(data=myGene,cutoff)
}
\references{
BOSS - Biomarker Optimal Segmentation System
}
