% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_vecm_ardl.R
\name{sim_vecm_ardl}
\alias{sim_vecm_ardl}
\title{Generate data from a VECM/ARDL equation}
\usage{
sim_vecm_ardl(
  nobs,
  case = 1,
  sigma.in,
  gamma.in,
  axx.in,
  ayx.uc.in,
  ayy.in,
  mu.in = NULL,
  eta.in = NULL,
  azero.in = NULL,
  aone.in = NULL,
  burn.in = nobs * 0.5,
  seed.in = NULL
)
}
\arguments{
\item{nobs}{number of observations.}

\item{case}{case related to intercept and trend}

\item{sigma.in}{error covariance matrix \eqn{\boldsymbol\Sigma}}

\item{gamma.in}{list of VECM short-run parameter matrices \eqn{\boldsymbol\Gamma_j}}

\item{axx.in}{long-run relationships between the independent variables \eqn{\mathbf A_{xx}}}

\item{ayx.uc.in}{long-run unconditional relationship between dependent and independent variables, \eqn{\mathbf a_{yx}}.
The second component ayxC, derived from conditioning, is calculated as \eqn{\mathbf a_{yx}^{(C)}= - \boldsymbol\omega'\mathbf A_{xx}}}

\item{ayy.in}{long-run relationship for the dependent variable \eqn{a_{yy}}}

\item{mu.in}{VAR intercept vector \eqn{\boldsymbol\mu} (CASE II)}

\item{eta.in}{VAR trend vector \eqn{\boldsymbol\eta} (CASE IV)}

\item{azero.in}{VECM intercept \eqn{\boldsymbol{\alpha}_{0}} (CASE III-IV-V)}

\item{aone.in}{VECM trend \eqn{\boldsymbol{\alpha}_{1}} (CASE V)}

\item{burn.in}{burn-in number of observations}

\item{seed.in}{optional seed number for random error generation.}
}
\value{
A list that includes \itemize{
\item \code{dims}: a vector with the dataset dimension
\item \code{case}: the case given as input
\item \code{data}: the generated data
\item \code{diffdata}: the data first difference
\item \code{ut}: the generated random error matrix.
\item \code{sigma}: the error covariance matrix \eqn{\boldsymbol\Sigma}.
\item \code{omega}: the \eqn{\boldsymbol\omega} vector of parameters generated via conditioning
\item \code{at}: the conditional long-run parameter matrix \eqn{\widetilde{\mathbf A}}
\item \code{ayy}: the coefficient weighting the EC term, \eqn{a_{yy}}
\item \code{ayx.uc}: the unconditional subvector of the ARDL equation \eqn{\mathbf a_{yx}}
\item \code{ayx2}: the conditioning effect \eqn{\omega'A_{xx}}
\item \code{ayx.c}: the conditional subvector of the ARDL equation \eqn{\widetilde{a}_{y.x}=a_{yx}-\omega'A_{xx}}
\item \code{gammalist}: the list of unconditional \eqn{\boldsymbol\Gamma_j} parameter matrices
\item \code{psilist}: the list of conditional \eqn{\boldsymbol\gamma_{y.x,j}} parameter matrices
\item \code{vmu}: the VAR intercept \eqn{\boldsymbol\mu}
\item \code{veta}: the VAR trend \eqn{\boldsymbol\eta}
\item \code{azero}: the unconditional VECM intercept \eqn{\boldsymbol\alpha_0}
\item \code{aone}: the unconditional VECM trend \eqn{\boldsymbol\alpha_1}
\item \code{azero.c}: the conditional VECM intercept \eqn{\boldsymbol\alpha_0^c}
\item \code{aone.c}: the conditional VECM trend \eqn{\boldsymbol\alpha_1^c}
\item \code{interc.ardl}: the conditional ARDL intercept \eqn{\alpha_{0.y}} (case > 2)
\item \code{trend.ardl}: the conditional ARDL trend \eqn{\alpha_{1.y}} (case = 5)
\item \code{theta0}: the \eqn{\theta_0} coefficient in the EC term (case = 2)
\item \code{theta1}: the \eqn{\theta_1} coefficient in the EC term (case = 4)
\item \code{interc.ec}: the conditional ARDL intercept derived from the EC tem \eqn{\alpha^{EC}_{0.y}} (case = 2)
\item \code{trend.ec}: the conditional ARDL trend derived from the EC tem \eqn{\alpha^{EC}_{1.y}} (case = 4)}
}
\description{
Generate data from a VECM/ARDL equation
}
\examples{
#PARAMETERS

#Sigma
corrm = matrix(0, ncol = 3, nrow = 3)
corrm[2,1] = 0.25
corrm[3,1] = 0.4
corrm[3,2] = -0.25
corrs = (corrm + t(corrm)) + diag(3)
sds = diag(c(1.3, 1.2, 1))
sigma = (sds \%*\% corrs \%*\% t(sds))

#Gamma
gammax = list()
gammax[[1]] = matrix(c(0.6, 0, 0.2, 0.1, -0.3, 0, 0, -0.3, 0.2), nrow = 3, ncol = 3, byrow = TRUE)
gammax[[2]] = matrix(c(0.2, 0, 0.1, 0.05, -0.15, 0, 0, 0, 0.1), nrow = 3, ncol = 3, byrow = TRUE)

#DATA GENERATION
data_sim = sim_vecm_ardl(nobs = 200,
                         case = 3,
                         sigma.in = sigma,
                         gamma.in = gammax,
                         axx.in = matrix(c(0.3, 0.5, 0.4, 0.3), nrow = 2, ncol = 2),
                         ayx.uc.in = c(0.5,0.6),
                         ayy.in = 0.7,
                         mu.in = rep(0, 3),
                         eta.in = rep(0, 3),
                         azero.in = rep(0.4, 3),
                         aone.in = rep(0, 3),
                         burn.in = 50,
                         seed.in = 10)

}
