% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facto_ca.R
\name{facto_ca}
\alias{facto_ca}
\title{Perform CA with FactoMineR's style}
\usage{
facto_ca(X, ncp = 5, row_sup = NULL, col_sup = NULL, weighted_row = NULL)
}
\arguments{
\item{X}{a data frame with n rows (individuals) and p columns (numeric variables)}

\item{ncp}{an integer, the number of components to keep (value set by default)}

\item{row_sup}{a vector indicating the indexes of the supplementary rows}

\item{col_sup}{a vector indicating the indexes of the supplementary cols}

\item{weighted_row}{row weights}
}
\value{
A list containing results of FactoMineR's correspondence analysis (CA).
}
\description{
Return CA results with FactoMineR's style
}
\examples{
library(booklet)
res <- facto_ca(X = mtcars[, c(2, 8:11)], ncp = 2)
}
