% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.elastic_net}
\alias{summary.elastic_net}
\title{Summary Elastic Net Function}
\usage{
\method{summary}{elastic_net}(object, gamma = 1, l = NULL, lambda = NULL, ...)
}
\arguments{
\item{object}{(\code{elastic_net})\cr the elastic_net object.}

\item{gamma}{(\code{scalar})\cr numeric value defining the weights to obtain
the average hazard ratio. Default is 1 (in this case the average hazard
ratio obtained can be interpreted as the odds of concordance). Just needed
when using survival data.}

\item{l}{(\code{scalar})\cr the maximum value of time that wants to be studied to
obtain the average hazard ratio. Default is the maximum value of time when
there was an event. Just needed when using survival data.}

\item{lambda}{(\code{scalar})\cr the penalization constant in the elastic net.
Default is the value that leads to minimal cross validation error.}

\item{...}{Arguments of summary}
}
\value{
Object of class \code{summary.elastic_net} which is a \code{list} with the
estimated subgroup treatment effects, the \code{resptype}, the confidence level
and the value of \code{alpha}.
}
\description{
Function to obtain the naive subgroup treatment effects of an object fitted
with the \code{elastic_net} function.
}
\examples{
summary(elastic_net_fit_surv)
}
