% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-core.R
\name{bs_align}
\alias{bs_align}
\title{Align the bitstream to the given number of bits - relative to start of bitstream}
\usage{
bs_align(bs, nbits = 8L, value = FALSE)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{nbits}{number of bits of alignment w.r.t start of bitstream. Default: 8}

\item{value}{bit fill value. Either TRUE or FALSE.  Default FALSE}
}
\value{
\code{Bitstream} connection returned invisibly
}
\description{
Align the bitstream to the given number of bits - relative to start of bitstream
}
\examples{
bs  <- bs_open(raw(), 'w')
bs_write_bit(bs, c(TRUE, FALSE, TRUE))
bs_is_aligned(bs, 8)
bs_align(bs, nbits = 8)
bs_is_aligned(bs, 8)
output <- bs_close(bs)
output
}
