% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_standards.R
\name{bf_standards}
\alias{bf_standards}
\title{Handle community standard protocols}
\usage{
bf_standards(
  protocol = NULL,
  remote = NULL,
  action = "list",
  version = "latest",
  change = NULL,
  token = NULL
)
}
\arguments{
\item{protocol}{\code{\link[=character]{character(1)}}\cr name of the bit-flag protocol
to handle. This is either used to filter the list retrieved from
\code{remote}, the name of the protocol to pull from github, or the name of
the new protocol that should be pushed to github.}

\item{remote}{\code{\link[=character]{character(1)}}\cr the path in the repo, where the
protocol is stored or shall be stored. For instance, to store a protocol in
\code{https://github.com/bitfloat/standards/distributions/type/distType.yml},
this should be \code{"distributions/type"}.}

\item{action}{\code{\link[=character]{character(1)}}\cr whether to \code{push} or
\code{pull} a protocol, or \code{list} the \code{remote} contents.}

\item{version}{\code{\link[=character]{character(1)}}\cr version tag for the protocol,
must have a semantic versioning pattern, i.e., \code{MAJOR.MINOR.PATCH}.}

\item{change}{\code{\link[=character]{character(1)}}\cr in case you try to push an
updated version of a protocol, you must provide a brief description of what
has changed from the current version to this version.}

\item{token}{\code{\link[=character]{character(1)}}\cr your github personal access token
(PAT).}
}
\value{
description
}
\description{
This function allows the user to list, pull or push bit-flag protocols to the
\href{https://github.com/bitfloat/standards}{bitfloat/standards} repository
on github
}
\details{
Create a Personal Access Token in your github developer settings (or
by running \code{usethis::create_github_token()}) and store it with
\code{gitcreds::gitcreds_set()}. The token must have the scope 'repo' so
you can authenticate yourself to pull or push community standards, and will
only be accessible to your personal R session.
}
\examples{
\dontrun{
# list all currently available standards
bf_standards()
}
}
