% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omnibus.R
\name{omnibus}
\alias{omnibus}
\alias{print.omnibus}
\title{Omnibus Tests for Comparing Three or More Groups}
\usage{
omnibus(
  data,
  y,
  x,
  paired_by = NULL,
  alpha = 0.05,
  p_method = "holm",
  na.action = "na.omit"
)

\method{print}{omnibus}(x, ...)
}
\arguments{
\item{data}{Dataframe containing the variables to be analyzed. Data must be in long format
with one row per observation.}

\item{y}{Character string indicating the dependent variable (outcome).}

\item{x}{An object of class "omnibus".}

\item{paired_by}{Character string indicating the source of repeated measurements. If
provided, a repeated measures design is assumed. If NULL, independent groups design is assumed.
Default: NULL.}

\item{alpha}{Numeric value indicating the significance level for hypothesis tests. Default: 0.05.}

\item{p_method}{Character string indicating the method for p-value adjustment in post-hoc multiple
comparisons to control for Type I error inflation. Options: "holm" (Holm), "hochberg" (Hochberg),
"hommel" (Hommel), "bonferroni" (Bonferroni), "BH" (Benjamini-Hochberg), "BY" (Benjamini-Yekutieli),
"none" (no adjustment). Default: "holm".}

\item{na.action}{Character string indicating the action to take if NAs are present ("na.omit"
or "na.exclude"). Default: "na.omit"}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class "omnibus" containing the formula, statistic summary,
name of the test performed, value of the test statistic, p value, alpha,
the results of the post-hoc test and assumptions, the sample size's
coefficient of variance, and corresponding degrees of freedom.
}
\description{
Performs omnibus tests to evaluate overall differences between three or more groups. Automatically
selects the appropriate statistical test based on data characteristics and assumption testing.
Supports both independent groups and repeated measures designs. Tests include one-way ANOVA, repeated
measures ANOVA, Kruskal-Wallis test, and Friedman test. Performs comprehensive assumption checking
(normality, homogeneity of variance, sphericity) and post-hoc testing when significant results are detected.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(omnibus)}: Print method for objects of class "omnibus".

}}
\examples{
# Simulated clinical data with multiple treatment arms and visits
clinical_df <- clinical_data(n = 300, visits = 6, arms = c("A", "B", "C"))

# Compare numerical variable across treatments
omnibus(data = clinical_df, y = "biomarker", x = "treatment")

# Filter simulated data to just one treatment
clinical_df_A <- clinical_df[clinical_df$treatment == "A", ]

# Compare numerical variable changes across visits 
omnibus(y = "biomarker", x = "visit", data = clinical_df_A, paired_by = "participant_id")

}
\references{
Blanca, M., Alarcón, R., Arnau, J. et al. Effect of variance ratio on ANOVA robustness: Might 1.5 be the limit?.
Behav Res. 2017 Jun 22; 50:937–962. https://doi.org/10.3758/s13428-017-0918-2
Field, A., Miles, J., & Field, Z. (2012). Discovering Statistics Using R. London: SAGE Publications.
}
