% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_delta_var.R
\name{calc_delta_var}
\alias{calc_delta_var}
\title{Calculate the change in variance with increasing number of sites}
\usage{
calc_delta_var(
  data,
  col_name,
  site_name = "num_sites",
  rep_name = "rep",
  visualize = FALSE
)
}
\arguments{
\item{data}{A data frame containing the biodiversity indices to analyze,
for a different number of sites over multiple repetitions.}

\item{col_name}{The name of the column containing the biodiversity index to
analyze.}

\item{site_name}{The name of the column containing the number of sites.}

\item{rep_name}{The name of the column containing the repetition number.}

\item{visualize}{A logical indicating whether to visualize the results.}
}
\value{
A data frame with the number of sites and the variance and standard
deviation of the mean of the biodiversity index for each number of
sites.
}
\description{
Calculate the change in variance with increasing number of sites
}
\examples{
ss <- generate_subsamples(BCI,
                         min_sites = 1,
                        max_sites = 5,
                       step = 1,
                     reps = 5)
data <- ss
data  <- unlist(data, recursive = FALSE)
data <- do.call(rbind, data)

calc_delta_var(data,
             col_name = "richness",
           site_name = "num_sites",
        rep_name = "rep",
     visualize = TRUE)
}
