% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotvf.R
\name{plotvf}
\alias{plotvf}
\title{Plots visual field}
\usage{
plotvf(xs, vf, title = "")
}
\arguments{
\item{xs}{A vector of horizontal coordinates. The length of it must be either 10 for a monocular or 25 for a binocular visual field plot.}

\item{vf}{A matrix of either a left/right monocular visual field or a binocular visual field sensitivity values}

\item{title}{A string for the name of the plot.}
}
\value{
A plot of a monocular or binocular visual field.
}
\description{
\code{plotvf} plots a figure of a visual field matrix with sensitivity threshold values
}
\section{Warning}{

the length of xs and the number of columns of the vf must be the same and with a value of either 10 or 20.
}

\examples{
m_xs <- seq(-27, 27, length.out = 10)
rghtvf <- matrix(c(
NA, NA, NA, 30, 30, 30, 30, NA, NA, NA,
NA, NA, 30, 30, 30, 30, 30, 30, NA, NA,
NA, 30, 30, 30, 30, 30, 30, 30, 30, NA,
30, 30, 30, 30, 30, 30, 30, 30, 30, NA,
30, 30, 30, 30, 30, 30, 30,  0, 30, NA,
NA, 30, 30, 30, 30, 30, 30, 30, 30, NA,
NA, NA, 30, 30, 30, 30, 30, 30, NA, NA,
NA, NA, NA, 30, 30, 30, 30, NA, NA, NA
), ncol=10, byrow=TRUE)
plotvf(m_xs, rghtvf, title='right visual field')
}
