% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_bids.R
\name{read_confounds.mock_bids_project}
\alias{read_confounds.mock_bids_project}
\title{Read Confound Files (Mock Implementation)}
\usage{
\method{read_confounds}{mock_bids_project}(
  x,
  subid = ".*",
  task = ".*",
  session = ".*",
  run = ".*",
  cvars = NULL,
  npcs = -1,
  perc_var = -1,
  nest = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{subid}{Regex pattern for subject IDs. Default \code{".*"}.}

\item{task}{Regex pattern for task names. Default \code{".*"}.}

\item{session}{Regex pattern for session IDs. Default \code{".*"}.}

\item{run}{Regex pattern for run indices. Default \code{".*"}.}

\item{cvars}{Variables to select (ignored in mock).}

\item{npcs}{PCA components (applied when requested).}

\item{perc_var}{PCA variance (applied when requested).}

\item{nest}{If \code{TRUE}, returns a nested tibble keyed by subject, task, session and run.}

\item{...}{Additional BIDS entities (passed to \code{search_files}).}
}
\value{
A \code{bids_confounds} tibble of confound data (nested if \code{nest = TRUE}).
}
\description{
Read Confound Files (Mock Implementation)
}
\examples{
parts <- c("01")
fs <- tibble::tibble(
  subid = "01", datatype = "func",
  suffix = c("bold.nii.gz", "desc-confounds_timeseries.tsv"),
  task = "rest", fmriprep = c(TRUE, TRUE)
)
conf_data <- list()
key <- "derivatives/fmriprep/sub-01/func/sub-01_task-rest_desc-confounds_timeseries.tsv"
conf_data[[key]] <- data.frame(
  csf = rnorm(50), white_matter = rnorm(50),
  trans_x = rnorm(50), trans_y = rnorm(50)
)
mock <- create_mock_bids("ConfTest", parts, fs, confound_data = conf_data)
conf <- read_confounds(mock)
print(conf)
}
