% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bids.R
\name{get_example_bids_dataset}
\alias{get_example_bids_dataset}
\title{Download Example BIDS Dataset}
\usage{
get_example_bids_dataset(dataset_name = "ds001")
}
\arguments{
\item{dataset_name}{Character string specifying which dataset to download.
Common options include "ds001", "ds002", "ds007", "phoneme_stripped", etc.}
}
\value{
Character string containing the path to the downloaded dataset directory.
}
\description{
Downloads and extracts an example BIDS dataset for testing and demonstration purposes.
The datasets are sourced from the official BIDS examples repository on GitHub.
}
\details{
This function requires an internet connection to download data from GitHub.
The datasets are cached in the temporary directory AND in memory for the session,
so repeated calls with the same dataset_name will reuse the already downloaded data.
Note: Don't call \code{unlink()} on the returned path in examples, as this defeats
the caching mechanism and forces re-downloads.
}
\examples{
\donttest{
tryCatch({
  ds_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds_path)
  print(participants(proj))
  
  # Dataset cache is intentionally retained for performance.
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
