% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCFunctions.R
\name{getAverageNSubjects}
\alias{getAverageNSubjects}
\title{getAverageNSubjects}
\usage{
getAverageNSubjects(scenario_list)
}
\arguments{
\item{scenario_list}{An object of class \code{scenario_list},
as created with \code{\link[bhmbasket]{simulateScenarios}} or
\code{\link[bhmbasket]{continueRecruitment}}}
}
\value{
A named list of vectors for the average number of subjects in each scenario.
}
\description{
This function calculates the average number of subjects per scenario.
}
\details{
This function can be useful to assess decision rules with regard to the average number
of subjects across scenarios when performing interim analyses.
}
\examples{
interim_scenarios <- simulateScenarios(
  n_subjects_list     = list(c(10, 20, 30)),
  response_rates_list = list(rep(0.9, 3)),
  n_trials            = 10)

interim_analyses <- performAnalyses(
  scenario_list       = interim_scenarios,
  target_rates        = rep(0.5, 3),
  n_mcmc_iterations   = 100)

interim_gos <- getGoDecisions(
  analyses_list       = interim_analyses,
  cohort_names        = c("p_1", "p_2", "p_3"),
  evidence_levels     = c(0.5, 0.8, 0.5),
  boundary_rules      = quote(c(x[1] > 0.8, x[2] > 0.6, x[3] > 0.7)))
    
scenarios_list <- continueRecruitment(
  n_subjects_add_list = list(c(30, 20, 10)),
  decisions_list      = interim_gos,
  method_name         = "exnex_adj")
  
getAverageNSubjects(scenarios_list)

}
\seealso{
\code{\link[bhmbasket]{simulateScenarios}}
\code{\link[bhmbasket]{continueRecruitment}}
}
\author{
Stephan Wojciekowski
}
