% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttler_fickel_dist.R
\name{buttler_fickel_dist}
\alias{buttler_fickel_dist}
\title{Buttler-Fickel Distance Matrix}
\usage{
buttler_fickel_dist(df, types)
}
\arguments{
\item{df}{A data.frame where rows are cases and columns are variables.}

\item{types}{A character vector of the same length as \code{ncol(df)},
indicating the scale level of each variable. Allowed values are
\code{"metric"}, \code{"ordinal"}, or \code{"nominal"}.}
}
\value{
An object of class \code{dist}.
}
\description{
Computes a distance matrix following Buttler & Fickel (1995) for mixed-scale
variables. Each variable-specific distance matrix is normalized by its mean
pairwise distance (Gini mean difference), ensuring equal contribution of all
variables to the overall distance.
}
