% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.brs}
\alias{summary.brs}
\title{Summarize a fitted model (betareg style)}
\usage{
\method{summary}{brs}(object, ...)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{...}{Ignored.}
}
\value{
A list of class \code{"summary.betaregscale"}.
}
\description{
Summarize a fitted model (betareg style)
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
s <- summary(fit)
s$coefficients$mean
}

}
\seealso{
\code{\link{brs}}, \code{\link{print.summary.brs}},
  \code{\link{brs_est}}, \code{\link{brs_gof}}
}
