% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.brs}
\alias{residuals.brs}
\title{Extract residuals}
\usage{
\method{residuals}{brs}(
  object,
  type = c("response", "pearson", "deviance", "rqr", "weighted", "sweighted"),
  ...
)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{type}{Residual type. One of \code{"response"} (default),
\code{"pearson"}, \code{"deviance"}, \code{"rqr"} (randomized
quantile), \code{"weighted"}, or \code{"sweighted"}.}

\item{...}{Currently ignored.}
}
\value{
Numeric vector of residuals.
}
\description{
Extract residuals
}
\details{
For Pearson residuals the variance formula depends on the
reparameterization stored in \code{object$repar}:
\describe{
  \item{repar = 1 (precision)}{V = mu(1 - mu) / (1 + phi)}
  \item{repar = 2 (mean-variance)}{V = mu(1 - mu) * phi}
}
The weighted and sweighted residuals use the digamma/trigamma
formulation from the precision parameterization (repar = 1),
so internal conversion is applied when \code{repar != 1}.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
head(residuals(fit))
head(residuals(fit, type = "pearson"))
}

}
\seealso{
\code{\link{brs}}, \code{\link{fitted.brs}}, \code{\link{plot.brs}}
}
