% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.brs}
\alias{print.brs}
\title{Print a fitted model (brief betareg style)}
\usage{
\method{print}{brs}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{A fitted \code{"betaregscale"} object.}

\item{digits}{Number of significant digits.}

\item{...}{Included for consistency with generic methods. Currently
passed to internal methods where applicable.}
}
\value{
Invisibly returns the input object \code{x}. The function is called
  for its side effect of printing a formatted summary of the fitted model
  to the console, including the model call, mean coefficients (with link
  function), and precision coefficients (with link function).
}
\description{
Print a fitted model (brief betareg style)
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
print(fit)
}

}
\seealso{
\code{\link{summary.brs}}, \code{\link{print.summary.brs}},
  \code{\link{brs}}
}
