% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{formula.brsmm}
\alias{formula.brsmm}
\title{Extract model formula}
\usage{
\method{formula}{brsmm}(x, ...)
}
\arguments{
\item{x}{A fitted \code{"brsmm"} object.}

\item{...}{Ignored.}
}
\value{
The formula used to fit the model.
}
\description{
Extract model formula
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
formula(fit)
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{model.matrix.brsmm}}
}
