% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-random-effects-study.R
\name{brsmm_re_study}
\alias{brsmm_re_study}
\title{Random-effects study for brsmm models}
\usage{
brsmm_re_study(object, ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{...}{Currently ignored.}
}
\value{
A list with class \code{"brsmm_re_study"}.
}
\description{
Provides a compact numeric study of random effects, including:
estimated covariance matrix, correlation matrix, per-term standard
deviations, empirical mean/SD of posterior modes, shrinkage ratio, and
a normality check by Shapiro-Wilk (when applicable).
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
rs <- brsmm_re_study(fit)
print(rs)
rs$summary
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Ferrari, S. L. P., and Cribari-Neto, F. (2004).
Beta regression for modelling rates and proportions.
\emph{Journal of Applied Statistics}, \bold{31}(7), 799--815.
\doi{10.1080/0266476042000214501}
}
\seealso{
\code{\link{brsmm}}, \code{\link{ranef.brsmm}}
}
