% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{rBetaMS}
\alias{rBetaMS}
\title{Random Draw from the Beta Probability Density Distribution With Specific Mean and Variance.}
\usage{
rBetaMS(n, mean, variance = NULL, sd = NULL, l = 0, u = 1)
}
\arguments{
\item{n}{Number of observations to be drawn from under the Standard Beta Probability Density Distribution.}

\item{mean}{The mean of the target Standard Beta probability density distribution.}

\item{variance}{The variance of the target Standard Beta probability density distribution.}

\item{sd}{The standard deviation of the target Standard probability density distribution.}

\item{l}{The lower-bound location parameter. Default set to 0 (the standard Beta distribution).}

\item{u}{The upper-bound location parameter. Default set to 1 (the standard Beta distribution).}
}
\value{
A vector of length \code{n}, each value representing a random draw from the Standard Beta probability density distribution with defined mean and variance.
}
\description{
Draws random samples of observations from the Standard Beta probability density distribution with defined mean and variance.
}
\examples{
# To draw a random sample of 100 values from a Standard Beta distribution
# with a mean of 0.6 and variance = 0.04:
rBetaMS(n = 100, mean = 0.6, variance = 0.04)

# To draw a random sample of 100 values from a Four-Parameter Beta
# 0 and an upper-bound of 100:
rBetaMS(n = 100, mean = 60, variance = 400, l = 0, u = 100)
}
