% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{qGammaBinom}
\alias{qGammaBinom}
\title{Quantile function for the Gamma-extended Binomial distribution.}
\usage{
qGammaBinom(p, size, prob, lower.tail = TRUE, precision = 1e-07)
}
\arguments{
\item{p}{Vector of probabilities.}

\item{size}{Number of "trials" (zero or more, including positive non-integers).}

\item{prob}{Probability of success on each "trial".}

\item{lower.tail}{Logical. If TRUE (default), probabilities are P[X < x], otherwise P[X > x].}

\item{precision}{The precision with which the quantile is to be calculated. Default is 1e-7 (i.e., search terminates when there is no registered change in estimate at the seventh decimal). Tuning this value will impact the time it takes for the search algorithm to arrive at an estimate.}
}
\description{
Quantile function for the Gamma-extended Binomial distribution.
}
\note{
This function uses a bisection search-algorithm to find the number of successes corresponding to the specified quantile(s). This algorithm is inefficient with respect to the number of iterations required to converge on the solution. More efficient algorithms might be added in later versions.
}
\examples{
# For a Gamma-extended Binomial distribution with number of trials = 10 and
# probability of success per trial of 0.75, calculate the number of success-
# ful trials at or below the 25\% quantile:
qGammaBinom(p = 0.25, size = 10, prob = 0.75)

# Conversely, for a Gamma-extended Binomial distribution with number of
# trials = 10 and probability of success per trial of 0.75, calculate the
# number of successful trials at or above the 25\% quantile:
qGammaBinom(p = 0.25, size = 10, prob = 0.75, lower.tail = FALSE)
}
\references{
Loeb, D. E. (1992). A generalization of the binomial coefficients. Discrete Mathematics, 105(1-3).
}
