% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{gchoose}
\alias{gchoose}
\title{Gamma-extended Binomial coefficient (choose function).}
\usage{
gchoose(n, k)
}
\arguments{
\item{n}{In Binomial terms, the number of Binomial "trials". Need not be an integer.}

\item{k}{In Binomial terms, the number of successful "trials". Need not be an integer.}
}
\description{
Extends the Binomial coefficient for positive non-integers (including 0) by employing the Gamma rather than the factorial function.
}
\note{
Not defined for negative integers.
}
\examples{
# Compare choose function with gchoose function for integers:
gchoose(c(8, 9, 10), c(3, 4, 5)) == choose(c(8, 9, 10), c(3, 4, 5))

# The gchoose function also works for non-integers:
gchoose(10.5, 7.5)
}
\references{
Loeb, D. E. (1992). A generalization of the binomial coefficients. Discrete Mathematics, 105(1-3).
}
